/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	PlaneThroughObjects.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT PlaneThroughObjects(ITopology *pFirstTopology, ITopology *pSecondTopology, CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch, long color, IWorkplane **retDispatch)
{
	START_METHOD("PlaneThroughObjects")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *currentWorkplane = NULL;
	IWorkplane *plane = NULL;
	IDesign *localDesign = NULL;
	ISet *workplanes = NULL;
	IGeometric *localGeometricFirst= NULL;
	IGeometric*localGeometricSecond= NULL;
	ISketch *sketch = NULL;
	IWorkplane * activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	IObject *object1 = NULL;
	IObject *object2 = NULL;
	ICommonPlane *commonplane = NULL;


	IDesign *pDesign= NULL;
	IGeometry *pGeom0= NULL;
	IGeometry *pGeom1= NULL;
	IWorkplane *pCommonplane= NULL;
	IColor *pNewColor= NULL;
	IDispatch *pWorkplanes = NULL;
	ICommonPlane *pCommon = NULL;
	IDispatch *pCurrentWorkplane = NULL;
	IDispatch *pActiveDoc = NULL;
	ISketch *pCommonplanesSketch = NULL;

	VARIANT_BOOL blnFirstTopology,blnSecondTopology;

	// check if the selected topologies belong to a TopologyClass
	// check for first topology
	CHECK_VAR_STATUS(pFirstTopology)
	object1 = CAST(IObject, pFirstTopology);

	status = object1->IsA(GetBSTR("Topology"),&blnFirstTopology);
	CHECK_RETURN_STATUS(status)

 	// check for second topology
	CHECK_VAR_STATUS(pSecondTopology)
	object2 = CAST(IObject, pSecondTopology);

	status = object2->IsA(GetBSTR("Topology"),&blnSecondTopology);
	CHECK_RETURN_STATUS(status)

	// if both the topologyclass is not NULL
	if (blnFirstTopology && blnSecondTopology) {
		status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
		CHECK_RETURN_STATUS(status)

		status = activePart->GetDesign(&pDesign);

		//    Create a CommonPlane
		status = (GetCLASS(CommonPlane))->CreateCommonPlane(&pCommon);

  		localGeometricFirst = CAST(IGeometric, pFirstTopology);

		// get the first topology geometry
		status = localGeometricFirst->GetGeometry(&pGeom0);
		CHECK_RETURN_STATUS(status)
  	
		localGeometricSecond = CAST(IGeometric, pSecondTopology);

		// get the first topology geometry
		status = localGeometricSecond->GetGeometry(&pGeom1);
		CHECK_RETURN_STATUS(status)   

		status = (GetCLASS(CommonPlane))->CreateCommonPlane(&pCommon);

      	status = pCommon->AddMember(pGeom0);
		status = pCommon->AddMember(pGeom1);

			// Create the PlaneThroughObjects Workplane
		status = pDesign->CreateWorkplane(CAST(IPlane,pCommon), workplaneName.AllocSysString(), &pCommonplane);
		if (status)
			return CONV_FAILURE;

		// Create a sketch with the given sketch name
		if(!bNoSketch)
		{
			plane = CAST(IWorkplane, pCommonplane);
			plane->CreateSketch(sketchName.AllocSysString(), &pCommonplanesSketch);
			
			activeGraphicDoc->SetActiveSketch(pCommonplanesSketch);

			// Set the color for the sketch
			if(color<0 || color > 11)
				color = 4;
			(GetCLASS(Color))->CreateColor(1, color*30, 0.35, 1, &pNewColor);
			sketch = CAST(ISketch, pCommonplanesSketch);

			sketch->SetColor(pNewColor);
		}
	}
	else
	{
		AfxMessageBox ("Improper Selection of Entities");
		pCommonplane = NULL;
	}
	*retDispatch=pCommonplane;
    END_METHOD("PlaneThroughObjects")
}
